using System;
using System.IO;
using System.Security;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program katalog");
      return;
    }
    String katalog = args[0];
    DirectoryInfo di;

    try{
      di = new DirectoryInfo(katalog);
    }
    catch(ArgumentException)
    {
      Console.WriteLine(
        "Nazwa {0} zawiera nieprawidłowe znaki.", katalog);
      return;
    }

    if(!di.Exists)
    {
      Console.WriteLine("Katalog {0} nie istnieje.", katalog);
      return;
    }

    try
    {
      di.Delete();
    }
    catch(IOException)
    {
      Console.WriteLine("Katalog {0} nie może zostać usunięty.", katalog);
      return;
    }
    catch(SecurityException)
    {
      Console.WriteLine("Brak uprawnień do usunięcia katalogu {0}.", katalog);
      return;
    }
    Console.WriteLine("Katalog {0} został usunięty.", katalog);
  }
}
